# 機能設計書 2-Visual Basicコンパイラ (vbc)

## 概要

本ドキュメントは、RoslynプラットフォームにおけるVisual Basicコンパイラ (vbc) の機能設計について記述する。vbcは、Visual BasicソースコードをIL (Intermediate Language/中間言語) にコンパイルするためのコマンドラインツールである。

### 本機能の処理概要

**業務上の目的・背景**：Visual Basicコンパイラは、.NETエコシステムにおいてVisual Basic言語を使用した開発を支援する中核的なツールである。レガシーなVB6からの移行アプリケーションや、Windowsフォームアプリケーション、ASP.NET WebFormsなど、多くの企業システムでVisual Basicが使用されており、これらのソースコードを実行可能なILコードに変換する役割を担う。C#コンパイラと同様にRoslynベースの実装となり、コンパイラAPIの公開やアナライザーの統合が可能となった。

**機能の利用シーン**：
- コマンドラインからの直接的なVBソースコードのコンパイル
- MSBuildビルドシステムからのVBプロジェクトビルド
- Visual Studio IDEでのバックグラウンドコンパイル
- CI/CDパイプラインでの自動ビルド処理
- レガシーVBアプリケーションの保守・更新

**主要な処理内容**：
1. コマンドライン引数の解析とオプション設定
2. ソースファイルの読み込みと構文解析 (Parsing)
3. 意味解析 (Semantic Analysis) とシンボル解決
4. VB固有のオプション処理 (Option Strict, Option Explicit, Option Infer)
5. コード生成 (IL Emit) とPEファイル出力
6. 診断情報 (警告・エラー) の生成と出力
7. アナライザーの実行とコード品質チェック

**関連システム・外部連携**：
- MSBuildビルドシステムとの統合
- Visual StudioホストオブジェクトAPI (IVbcHostObject) との連携
- Roslynアナライザーとソースジェネレーターの実行基盤
- Microsoft.VisualBasic.dllランタイムライブラリ

**権限による制御**：特に権限による実行制御は存在しない。ファイルシステムへの読み書き権限のみが必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | コマンドラインツールのため画面は存在しない |

## 機能種別

計算処理 / コード変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| args | string[] | Yes | コマンドライン引数 | 構文チェック |
| ソースファイル | ファイルパス | Yes | コンパイル対象のVBソースファイル | ファイル存在確認、拡張子チェック (.vb) |
| /out | string | No | 出力ファイル名 | パス形式チェック |
| /target | string | No | 出力種別 (exe/library/module/winexe) | 列挙値チェック |
| /reference | string[] | No | 参照アセンブリ | ファイル存在確認 |
| /define | string | No | プリプロセッサシンボル | 識別子形式チェック |
| /optionstrict | string | No | 厳格な型チェック (On/Off/Custom) | 列挙値チェック |
| /optionexplicit | bool | No | 変数の明示的宣言を強制 | - |
| /optioninfer | bool | No | 型推論の有効化 | - |
| /optioncompare | string | No | 文字列比較モード (Text/Binary) | 列挙値チェック |
| /imports | string[] | No | グローバルインポート名前空間 | 名前空間形式チェック |
| /langversion | string | No | 言語バージョン | サポートバージョンチェック |

### 入力データソース

- Visual Basicソースファイル (.vb)
- レスポンスファイル (.rsp)
- 参照アセンブリ (.dll)
- Microsoft.VisualBasic.dll (VBランタイム)

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 出力アセンブリ | PE ファイル | コンパイル結果の.dll または .exe |
| PDBファイル | PDB | デバッグシンボル情報 |
| XMLドキュメント | XML | APIドキュメント (オプション) |
| 診断メッセージ | テキスト | エラー・警告メッセージ |
| 終了コード | int | 0=成功、1=失敗 |

### 出力先

- ファイルシステム (指定された出力ディレクトリ)
- 標準出力・標準エラー出力 (診断メッセージ)

## 処理フロー

### 処理シーケンス

```
1. エントリーポイント (Program.Main)
   └─ コマンドライン引数の受け取りとBuildClientへの委譲

2. BuildClient.Run の実行
   └─ RequestLanguage.VisualBasicCompile指定でコンパイラサーバー接続

3. Vbc.Run の呼び出し
   └─ VisualBasicCompilerインスタンスの生成と実行

4. コマンドライン引数の解析 (VisualBasicCommandLineParser)
   └─ VB固有オプションの解析とVisualBasicCommandLineArgumentsの生成

5. コンパイル処理 (CreateCompilation)
   └─ ソースファイルの並列パース
   └─ 参照アセンブリの解決
   └─ VBランタイム参照の自動追加
   └─ VisualBasicCompilationの生成

6. アナライザー実行
   └─ 診断アナライザーの実行
   └─ ソースジェネレーターの実行

7. コード生成 (Emit)
   └─ IL生成とPEファイル出力
   └─ PDBファイル生成

8. 結果出力
   └─ 診断メッセージの出力
   └─ 終了コードの返却
```

### フローチャート

```mermaid
flowchart TD
    A[Program.Main開始] --> B[BuildClient.Run呼び出し]
    B --> C{コンパイラサーバー利用可能?}
    C -->|Yes| D[サーバー経由でコンパイル]
    C -->|No| E[インプロセスでコンパイル]
    D --> F[Vbc.Run実行]
    E --> F
    F --> G[コマンドライン解析]
    G --> H{解析成功?}
    H -->|No| I[エラー出力して終了]
    H -->|Yes| J[ソースファイルのパース]
    J --> K[VBオプション適用]
    K --> L[参照の解決]
    L --> M[VBランタイム参照追加]
    M --> N[VisualBasicCompilation生成]
    N --> O[アナライザー実行]
    O --> P[Emit処理]
    P --> Q{コンパイル成功?}
    Q -->|Yes| R[終了コード0で終了]
    Q -->|No| S[エラー出力、終了コード1で終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | Option Strict制約 | 暗黙の型変換を制限 | /optionstrict:on指定時 |
| BR-02 | Option Explicit制約 | 変数の明示的宣言が必須 | /optionexplicit:on指定時 (既定) |
| BR-03 | Option Infer動作 | ローカル変数の型推論を有効化 | /optioninfer:on指定時 |
| BR-04 | Option Compare動作 | 文字列比較のモード (Text:大文字小文字無視, Binary:バイナリ比較) | 指定時 |
| BR-05 | VBランタイム参照 | Microsoft.VisualBasic.dllを自動参照 | /novbruntimereference指定なし時 |
| BR-06 | グローバルインポート | /importsで指定した名前空間を全ファイルで使用可能 | /imports指定時 |

### 計算ロジック

特になし (変換処理のため)

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| BC30001-39999 | 構文/意味エラー | ソースコードの問題 | コード修正 |
| BC40000-49999 | 警告 | コードの品質問題 | コード改善推奨 |
| BC50000-59999 | 情報 | 参考情報 | 確認のみ |
| Fatal | 致命的エラー | メモリ不足等 | リソース確保 |

### リトライ仕様

リトライ処理は存在しない。コンパイルは単発実行。

## トランザクション仕様

トランザクション処理は存在しない。

## パフォーマンス要件

- 並列コンパイルオプションによる並列処理サポート (ConcurrentBuild)
- コンパイラサーバーによるウォームスタート
- インクリメンタルコンパイルのサポート

## セキュリティ考慮事項

- 厳格な名前付け (Strong Naming) のサポート
- 署名キーの保護機能
- Option Strictによる型安全性の強化

## 備考

- 既定のレスポンスファイル (vbc.rsp) は /noconfig オプションで無効化可能
- Visual Studioとの統合時はホストコンパイラオブジェクト (IVbcHostObject) を使用
- VBランタイム参照は /novbruntimereference で無効化可能 (VBランタイム自体のビルド時等)

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コンパイラの入出力を定義するデータ構造から理解を開始する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VisualBasicCommandLineArguments.vb | `src/Compilers/VisualBasic/Portable/CommandLine/VisualBasicCommandLineArguments.vb` | VB固有のコマンドライン引数を保持するデータ構造 |
| 1-2 | VisualBasicCompilationOptions.vb | `src/Compilers/VisualBasic/Portable/Compilation/VisualBasicCompilationOptions.vb` | VBコンパイルオプションの定義 (OptionStrict, OptionExplicit等) |

**読解のコツ**: VisualBasicCommandLineArgumentsはCommandLineArgumentsを継承しており、VB固有のオプション（OptionStrict, OptionExplicit, OptionInfer, Imports等）が追加されている。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Program.cs | `src/Compilers/VisualBasic/vbc/Program.cs` | コマンドラインエントリーポイント |

**主要処理フロー**:
1. **16-29行目**: Main関数でFileNotFoundExceptionをキャッチしてエラー処理
2. **31-40行目**: MainCoreでCompilerServerLoggerを初期化し、BuildClient.Runを呼び出し
3. **39行目**: RequestLanguage.VisualBasicCompileでVB用コンパイルをリクエスト
4. **42-43行目**: Runメソッドで外部からの呼び出しをサポート

#### Step 3: コンパイラ本体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VisualBasicCompiler.vb | `src/Compilers/VisualBasic/Portable/CommandLine/VisualBasicCompiler.vb` | コンパイラのメインロジック |
| 3-2 | VisualBasicCommandLineParser.vb | `src/Compilers/VisualBasic/Portable/CommandLine/VisualBasicCommandLineParser.vb` | コマンドライン解析 |

**主要処理フロー**:
- **15-16行目**: CommonCompilerを継承したVisualBasicCompilerクラス定義
- **18行目**: レスポンスファイル名 "vbc.rsp" の定義
- **87-150行目**: CreateCompilationメソッドでソースファイルのパースと参照解決
- **103-130行目**: 並列/逐次でのソースファイルパース処理

#### Step 4: MSBuildタスクを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Vbc.cs | `src/Compilers/Core/MSBuildTask/Vbc.cs` | MSBuildからのVBコンパイル呼び出し |

**主要処理フロー**:
- **28行目**: ManagedCompilerを継承したVbcクラス定義
- **42行目**: RequestLanguage.VisualBasicCompileの指定
- **127-143行目**: OptionStrict, OptionExplicit, OptionInferのプロパティ定義

### プログラム呼び出し階層図

```
Program.Main
    │
    ├─ BuildClient.Run (RequestLanguage.VisualBasicCompile)
    │      │
    │      └─ Vbc.Run
    │             │
    │             └─ VisualBasicCompiler (継承: CommonCompiler)
    │                    │
    │                    ├─ VisualBasicCommandLineParser.Parse
    │                    │
    │                    ├─ CreateCompilation
    │                    │      │
    │                    │      ├─ ParseFile (並列)
    │                    │      │
    │                    │      ├─ VBランタイム参照追加
    │                    │      │
    │                    │      └─ VisualBasicCompilation.Create
    │                    │
    │                    └─ RunCore (CommonCompiler)
    │                           │
    │                           ├─ ResolveAnalyzers
    │                           │
    │                           └─ Emit
    │
    └─ 終了コード返却
```

### データフロー図

```
[入力]                       [処理]                              [出力]

コマンドライン引数     ──▶  VisualBasicCommandLineParser   ──▶  VisualBasicCommandLineArguments
        │                                                               │
        ▼                                                               ▼
VBソースファイル       ──▶  VisualBasicSyntaxTree.ParseText ──▶  SyntaxTree[]
        │                                                               │
        ▼                                                               ▼
参照アセンブリ         ──▶  ResolveMetadataReferences       ──▶  MetadataReference[]
        │                                                               │
        ▼                                                               ▼
VBランタイム           ──▶  自動参照追加                     ──▶  Microsoft.VisualBasic.dll参照
        │                                                               │
        ▼                                                               ▼
                            VisualBasicCompilation.Create    ──▶  VisualBasicCompilation
                                       │
                                       ▼
                            CompilationWithAnalyzers
                                       │
                                       ▼
                                 Emit
                                       │
                       ┌───────────────┴───────────────┐
                       ▼                               ▼
               アセンブリファイル (.dll/.exe)      PDBファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Program.cs | `src/Compilers/VisualBasic/vbc/Program.cs` | ソース | コマンドラインエントリーポイント |
| VisualBasicCompiler.vb | `src/Compilers/VisualBasic/Portable/CommandLine/VisualBasicCompiler.vb` | ソース | VBコンパイラ本体 |
| VisualBasicCommandLineParser.vb | `src/Compilers/VisualBasic/Portable/CommandLine/VisualBasicCommandLineParser.vb` | ソース | コマンドライン解析 |
| VisualBasicCommandLineArguments.vb | `src/Compilers/VisualBasic/Portable/CommandLine/VisualBasicCommandLineArguments.vb` | ソース | 引数データ構造 |
| CommandLineDiagnosticFormatter.vb | `src/Compilers/VisualBasic/Portable/CommandLine/CommandLineDiagnosticFormatter.vb` | ソース | 診断メッセージフォーマット |
| Vbc.cs | `src/Compilers/Core/MSBuildTask/Vbc.cs` | ソース | MSBuildタスク定義 |
| CommonCompiler.cs | `src/Compilers/Core/Portable/CommandLine/CommonCompiler.cs` | ソース | 共通コンパイラ基盤 |
| vbc.rsp | `src/Compilers/VisualBasic/vbc/vbc.rsp` | 設定 | 既定レスポンスファイル |
